define(['angular', 'app'], function (angular, app) {
	"use strict";

	app.service('AbstractWeeklyGoalsService', function (FitnessActivityFHIRService, FitnessGoalsFHIRService,CollectionCRUDService, formatter, localResourceDirectoryService) {
		var AbstractWeeklyGoalsService = function(extension){



			var config = {},
				key = extension.object.dateKey;

			config.dependency = {
				service : FitnessActivityFHIRService, FitnessGoalsFHIRService
			};

			config.collection = {
				filter : function(list, filters) {
					if (filters === null || angular.equals(filters, {})) {
						return list;
					} else {

						// Reversed An edit here to let the charts look for any goals LN

						if(!filters.hasOwnProperty('activeFlag')) {
							return list.filter(function(item){
								return filters.activeFlag === item.activeFlag;
							});
						} else {
							return list;
						}
					}
				}
			};

			config.object = {
				uidKey : "_id",
				responseTransform : function(item) {
					item[key] = formatter.getFormattedFrontendDate(item[key]);
					return item;
				},
				requestTransform : function(item) {
					item[key] = formatter.getFormattedBackendDateTime(item[key]);
					return item;
				}
			};

			angular.element.extend(true, config, extension);

			CollectionCRUDService.call(this, config);

			this.promptedThisSession = false;



			this.createEmpty = function(){
				return angular.copy(extension.object.defaults);
			};
		};

		AbstractWeeklyGoalsService.prototype = Object.create(CollectionCRUDService.prototype);
		AbstractWeeklyGoalsService.prototype.constructor = AbstractWeeklyGoalsService;

		return AbstractWeeklyGoalsService;
	});
});